#!/usr/bin/python

from ROOT import TCanvas, TFile, TLatex, TLine, TPad, TProfile
from ROOT import gPad
from ROOT import kBlue

small = 1E-8

def LEDPlot(fname = "asymmetry_B.root") :
    c = TCanvas("LED", "LED", 1200, 600)
    f = TFile(fname)
    h = [f.Get("LED/led_profile_upper"), f.Get("LED/led_profile_lower")]

    for j in h :
        j.Rebin(10)
        j.GetYaxis().SetTitle("Mean LED Channel")
        j.GetYaxis().SetTitleSize(0.12)
        j.GetYaxis().SetTitleOffset(0.5)
        j.GetYaxis().SetTitleFont(tfont)
        j.GetYaxis().SetLabelSize(0.1)
        j.GetYaxis().SetLabelFont(tfont)
        j.GetXaxis().SetRangeUser(0., 4990)

    h[0].GetXaxis().SetLabelSize(0.)
    h[0].GetXaxis().SetTitleSize(0.)
    h[1].GetYaxis().SetRangeUser(2655, 2698)
    h[1].GetXaxis().SetTitle("Time since AC-MOT off [#mus]")
    h[1].GetXaxis().SetTitleSize(0.12)
    h[1].GetXaxis().SetTitleOffset(0.85)
    h[1].GetXaxis().SetLabelSize(0.1)
    h[1].GetXaxis().SetTitleFont(tfont)
    h[1].GetXaxis().SetLabelFont(tfont)

    c.Divide(1, 2)
    
    c.cd(1)
    gPad.SetBottomMargin(small)
    gPad.SetRightMargin(1.2*gPad.GetRightMargin())
    h[0].Draw("E1X0")
    gPad.Update()
    lup = TLine(1906., gPad.GetUymin(), 1906., gPad.GetUymax())
    lup.SetLineColor(kBlue)
    lup.SetLineStyle(2)
    lup.SetLineWidth(4)
    lup.Draw()

    tl = TLatex(100., 3691, "Optical Pumping: #vec{B} constant")
    tl.SetTextSize(h[1].GetYaxis().GetTitleSize())
    tl.SetTextColor(lup.GetLineColor())    
    tl.SetTextFont(tfont)
    tl.Draw()


    tm = TLatex(1919, 3653, "MOT: #vec{B} at 699.3 Hz")
    tm.SetTextSize(h[1].GetYaxis().GetTitleSize())
    tm.SetTextColor(lup.GetLineColor())
    tm.SetTextFont(tfont)
    tm.Draw()

    c.cd(2)
    gPad.SetTopMargin(small)
    gPad.SetRightMargin(1.2*gPad.GetRightMargin())
    gPad.SetBottomMargin(1.1*gPad.GetBottomMargin())
    h[1].Draw("E1X0")
    gPad.Update()
    llo = TLine(1906., gPad.GetUymin(), 1906., gPad.GetUymax())
    llo.SetLineColor(kBlue)
    llo.SetLineStyle(2)
    llo.SetLineWidth(4)
    llo.Draw()

    c.Update()
    uc = raw_input("Enter \"SAVE\" to save as .eps for thesis\n")
    if (uc == "SAVE") :
        c.SaveAs("~/Documents/Reports/Images/scintillators_led.eps")

    
